/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.filters;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import net.coobird.thumbnailator.filters.ImageFilter;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.util.BufferedImages;

public class Caption
implements ImageFilter {
    private final String caption;
    private final Font font;
    private final Color c;
    private final float alpha;
    private final Position position;
    private final int insets;

    public Caption(String string2, Font font, Color color, float f2, Position position2, int n) {
        this.caption = string2;
        this.font = font;
        this.c = color;
        this.alpha = f2;
        this.position = position2;
        this.insets = n;
    }

    public Caption(String string2, Font font, Color color, Position position2, int n) {
        this.caption = string2;
        this.font = font;
        this.c = color;
        this.alpha = 1.0f;
        this.position = position2;
        this.insets = n;
    }

    public BufferedImage apply(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = BufferedImages.copy(bufferedImage);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setFont(this.font);
        graphics2D.setColor(this.c);
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.alpha));
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = graphics2D.getFontMetrics().stringWidth(this.caption);
        int n4 = graphics2D.getFontMetrics().getHeight() / 2;
        Point point = this.position.calculate(n, n2, n3, 0, this.insets, this.insets, this.insets, this.insets);
        double d = (double)point.y / (double)bufferedImage.getHeight();
        int n5 = (int)((1.0 - d) * (double)n4);
        graphics2D.drawString(this.caption, point.x, point.y + n5);
        graphics2D.dispose();
        return bufferedImage2;
    }
}

